package gov.va.vamf.scheduling.facility.domain;

import com.agilex.healthcare.veteranappointment.domain.Namespace;
import com.agilex.healthcare.veteranappointment.domain.VARDomainTransferObjectCollection;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "facility", namespace = Namespace.VeteranAppointmentRequest)
@XmlAccessorType(value = XmlAccessType.NONE)
public class CDWFacility {

	private static final long serialVersionUID = -1177618870452594081L;

	@XmlElement
	private String name;
	@XmlElement
	private String type;
	@XmlElement
	private String facilityCode;
	@XmlElement
	private String state;
	@XmlElement
	private String city;
	@XmlElement
	private String address;
	@XmlElement
	private String parentSiteCode;
	@XmlElement
	private ArrayList<CDWFacility> children;
	
	public CDWFacility() {}
	
	public CDWFacility(String name, String type, String facilityCode, String state, String city, String address, String parentSiteCode) {
		this.name = name;
		this.type = type;
		this.facilityCode = facilityCode;
		this.state = state;
		this.city = city;
		this.address = address;
		this.parentSiteCode = parentSiteCode;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getFacilityCode() {
		return facilityCode;
	}

	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getParentSiteCode() {
		return parentSiteCode;
	}

	public void setParentSiteCode(String parentSiteCode) {
		this.parentSiteCode = parentSiteCode;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		result = prime * result + ((facilityCode == null) ? 0 : facilityCode.hashCode());
		result = prime * result + ((state == null) ? 0 : state.hashCode());
		result = prime * result + ((city == null) ? 0 : city.hashCode());
		result = prime * result + ((address == null) ? 0 : address.hashCode());
		result = prime * result + ((parentSiteCode == null) ? 0 : parentSiteCode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		if (this == obj) {
			result = true;
		} else if (obj != null && obj instanceof CDWFacility) {
			CDWFacility that = (CDWFacility) obj;

			if (equals(name, that.name)) {
				if (equals(type, that.type)) {
					if (equals(facilityCode, that.facilityCode)) {
						if (equals(state, that.state)) {
							if (equals(city, that.city)) {
								if (equals(address, that.address)) {
									if (equals(parentSiteCode, that.parentSiteCode)) {
										result = true;
									}
								}
							}
						}
					}
				}
			}
		}
		
		return result;
	}
	
	private boolean equals(Object one, Object two) {
		boolean result = false;
		if ((one == null && two == null)
				|| (one != null && one.equals(two))) {
			result = true;
		}
		return result;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(facilityCode);
		sb.append(" ");
		sb.append(name);
		
		return sb.toString();
	}

	public ArrayList<CDWFacility> getChildren() {
		return children;
	}

	public void setChildren(ArrayList<CDWFacility> children) {
		this.children = children;
	}
}
